
function [wordsB_DR, MFsB, CsB, ClB, CrB]=getFLIA_secondpart(ppmenu14string)

%% -- Read Data------------------------------
B = xlsread('data_secondpart_Left1.xls'); %% read the data from the first part of the survey
[rowB, colB] = size(B);

%% --- Input the names of words --------------
ppmenu14string; %% Words for the SECOND SURVEY

MFsB=zeros(colB/2,9);

%% ---- compute the FOUs and centroids FOR THE SECOND SURVEY --------------------
for i=1:colB/2
     LB = B(1:rowB, 2*i-1);  %%Read the left end points for interval data.
    RB = B(1:rowB, 2*i);    %%Read the right end points for interval data.
    [MFsB(i,:),nB(i),Stat, NNum, Shift(i,:)] = Fuzzistics_FL1(LB,RB); %%Determine the interval type-2 MFs and the number of remaining interval data m* for each word.
   [CsB(i), ClB(i), CrB(i)]=centroid(MFsB(i,:)); %%Compute the center of the centroid and the centroid of interval type-2 MFs.
end

%% -- sort the MFs in ascending order according to the center of centroid SECOND SURVEY--
[CsB,indexB]=sort(CsB);  %% Sort the center of the centroid
MFsB=MFsB(indexB,:);     %% Reorder the MFs based on the sorting of the center of centroids
ClB=ClB(indexB);         %% Reorder the left end of the centroid.
CrB=CrB(indexB);         %% Reorder the right end of the centroid.
wordsB_DR=ppmenu14string(indexB,:); %%Reorder the names of words.
